Rem ExportAllStories.vbs
Rem An InDesign VBScript
Rem
Rem Exports all stories in an InDesign document in a specified text format.
Rem InDesign will export each story as a separate file, and will name each
Rem file with the ID of the story (each ID is unique within a document).
Rem
Rem For more on InDesign/InCopy scripting see the documentation included in the Scripting SDK 
Rem available at http://www.adobe.com/devnet/indesign/sdk.html
Rem Or visit the InDesign scripting forum at http://www.adobeforums.com.
main
Function main()
	Set myInDesign = CreateObject("InDesign.Application.2022")
	Rem Set the user interaction level to allow the display of dialog boxes and alerts.
	myInDesign.ScriptPreferences.UserInteractionLevel = idUserInteractionLevels.idInteractWithAll
	If myInDesign.Documents.Count > 0 Then
	    If myInDesign.ActiveDocument.Stories.Count > 0 Then
	        myDisplayDialog myInDesign
	    Else
	        MsgBox ("The active document does not contain any text. Please open a document containing text and try again.")
	    End If
	Else
	    MsgBox ("No documents are open. Please open a document and try again.")
	End If
End Function
Function myDisplayDialog(myInDesign)
    Set myDialog = myInDesign.Dialogs.Add
    myDialog.Name = "ExportAllStories"
    With myDialog
        Rem Add a dialog column.
        With .DialogColumns.Add
            With .BorderPanels.Add
                With .StaticTexts.Add
                    .StaticLabel = "Export as:"
                End With
                Set myExportFormatButtons = .RadiobuttonGroups.Add
                With myExportFormatButtons
                    With .RadiobuttonControls.Add
                        .StaticLabel = "Text Only"
                        .CheckedState = True
                    End With
                    With .RadiobuttonControls.Add
                        .StaticLabel = "RTF"
                    End With
                    With .RadiobuttonControls.Add
                        .StaticLabel = "InDesign Tagged Text"
                    End With
                End With
            End With
        End With
    End With
    myReturn = myDialog.Show
    If myReturn = True Then
        Rem Get the values from the dialog box.
        myExportFormat = myExportFormatButtons.SelectedButton
        myDialog.Destroy
        Rem Creating a folder browser in VBScript can be difficult,
        Rem So we'll use InDesign's built-in JavaScript to display a
        Rem file browser.
        myJavaScript = "myFolder = Folder.selectDialog(""Choose a Folder"");app.activeDocument.insertLabel(""TargetFolder"", myFolder.fsName);"
        myInDesign.DoScript myJavaScript, idScriptLanguage.idJavascript
        Rem Now get the stored folder path from the label.
        myFolder = myInDesign.ActiveDocument.ExtractLabel("TargetFolder")
        Rem Now get the stored folder path from the label.
        myFolder = myInDesign.ActiveDocument.ExtractLabel("TargetFolder")
        If ((myFolder <> "") And (myInDesign.ActiveDocument.Stories.Count <> 0)) Then
            myExportAllStories myInDesign, myExportFormat, myFolder
        End If
    Else
        myDialog.Destroy
    End If
End Function
Rem myExportStories function takes care of exporting the stories.
Rem myExportFormat is a number from 0-2, where 0 = text only, 1 = rtf, and 3 = tagged text.
Rem myFolder is the path to the folder in which you want to save your files.
Function myExportAllStories(myInDesign, myExportFormat, myFolder)
    For myCounter = 1 To myInDesign.ActiveDocument.Stories.Count
        Set myStory = myInDesign.ActiveDocument.Stories.Item(myCounter)
        myID = myStory.Id
        Select Case myExportFormat
            Case 0:
                myFormat = idExportFormat.idTextType
                myExtension = ".txt"
            Case 1:
                myFormat = idExportFormat.idRTF
                myExtension = ".rtf"
            Case 2:
                myFormat = idExportFormat.idTaggedText
                myExtension = ".txt"
        End Select
        Rem DoScript(Script, [Language As idScriptLanguage = idUnknown])
        myFilePath = myFolder & "/" & "StoryID" & myID & myExtension
        myStory.Export myFormat, myFilePath
    Next
End Function

'' SIG '' Begin signature block
'' SIG '' MIIhPQYJKoZIhvcNAQcCoIIhLjCCISoCAQExDzANBglg
'' SIG '' hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
'' SIG '' BgEEAYI3AgEeMCQCAQEEEE7wKRaZJ7VNj+Ws4Q8X66sC
'' SIG '' AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
'' SIG '' JoKHQTno5qx2sTjKcMFiMcG4uLiWw/b4oOl8I1Xu3nqg
'' SIG '' ggyUMIIF0DCCBLigAwIBAgIQCHK5i9aO5k82w+FiDw5C
'' SIG '' dzANBgkqhkiG9w0BAQsFADBsMQswCQYDVQQGEwJVUzEV
'' SIG '' MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
'' SIG '' d3cuZGlnaWNlcnQuY29tMSswKQYDVQQDEyJEaWdpQ2Vy
'' SIG '' dCBFViBDb2RlIFNpZ25pbmcgQ0EgKFNIQTIpMB4XDTIw
'' SIG '' MTIxOTAwMDAwMFoXDTIyMTIyMTIzNTk1OVowgeYxEzAR
'' SIG '' BgsrBgEEAYI3PAIBAxMCVVMxGTAXBgsrBgEEAYI3PAIB
'' SIG '' AhMIRGVsYXdhcmUxHTAbBgNVBA8MFFByaXZhdGUgT3Jn
'' SIG '' YW5pemF0aW9uMRAwDgYDVQQFEwcyNzQ4MTI5MQswCQYD
'' SIG '' VQQGEwJVUzELMAkGA1UECBMCY2ExETAPBgNVBAcTCFNh
'' SIG '' biBKb3NlMRMwEQYDVQQKEwpBZG9iZSBJbmMuMSwwKgYD
'' SIG '' VQQLEyNJbGx1c3RyYXRvciwgSW5EZXNpZ24sIEluQ29w
'' SIG '' eSwgTXVzZTETMBEGA1UEAxMKQWRvYmUgSW5jLjCCASIw
'' SIG '' DQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAKraHbKp
'' SIG '' 7LWhQb1eUijAwzznOPnL0ar6Bh5IyTX0X3Nmx0y/zOPp
'' SIG '' A769ixYCLdufIms+U9xBOpXey6jajunMtomUtqLHkYMN
'' SIG '' DT2jzWOCqLvnwrHjehFxLYwYIt9ymU0VqJHPcIO+0lfA
'' SIG '' s4ZoskzD5OepJsCVjURfwILDS/l51c42dKXqbPmr25vz
'' SIG '' UQBlKIg7JV7JJGj29DQMOeCI9LSY4dAUYsfaEfDx0dcb
'' SIG '' T/oDlUZAH/mGrvFonoqGwLDNNSpWkFauC3ryUlgMJ6if
'' SIG '' JX9iZIrdm6Glo/EvxbsHMzsL2TclgBXoa0mYq4PYgMH1
'' SIG '' 5XYNA9y4x7QNLRmWPpXU+4gnfN0CAwEAAaOCAfEwggHt
'' SIG '' MB8GA1UdIwQYMBaAFI/ofvBtMmoABSPHcJdqOpD/a+rU
'' SIG '' MB0GA1UdDgQWBBS5nvze3WzR/65rffm/COInbJUTtzAu
'' SIG '' BgNVHREEJzAloCMGCCsGAQUFBwgDoBcwFQwTVVMtREVM
'' SIG '' QVdBUkUtMjc0ODEyOTAOBgNVHQ8BAf8EBAMCB4AwEwYD
'' SIG '' VR0lBAwwCgYIKwYBBQUHAwMwewYDVR0fBHQwcjA3oDWg
'' SIG '' M4YxaHR0cDovL2NybDMuZGlnaWNlcnQuY29tL0VWQ29k
'' SIG '' ZVNpZ25pbmdTSEEyLWcxLmNybDA3oDWgM4YxaHR0cDov
'' SIG '' L2NybDQuZGlnaWNlcnQuY29tL0VWQ29kZVNpZ25pbmdT
'' SIG '' SEEyLWcxLmNybDBLBgNVHSAERDBCMDcGCWCGSAGG/WwD
'' SIG '' AjAqMCgGCCsGAQUFBwIBFhxodHRwczovL3d3dy5kaWdp
'' SIG '' Y2VydC5jb20vQ1BTMAcGBWeBDAEDMH4GCCsGAQUFBwEB
'' SIG '' BHIwcDAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGln
'' SIG '' aWNlcnQuY29tMEgGCCsGAQUFBzAChjxodHRwOi8vY2Fj
'' SIG '' ZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRFVkNvZGVT
'' SIG '' aWduaW5nQ0EtU0hBMi5jcnQwDAYDVR0TAQH/BAIwADAN
'' SIG '' BgkqhkiG9w0BAQsFAAOCAQEALl6DDJXB+ruS0J/n4zd6
'' SIG '' IxqKGcJnnn72tgm50zJjxjqD9f4gMlY5lFA4Dcz9D6ur
'' SIG '' Yc734LqeT9p+oUv2PI4KdFMpSmhdrKLkI8eTK46NHVW8
'' SIG '' U/GZctdsVZR1JvtI1ByrH/DkQS7HTKWwtbyOkKU7lfYK
'' SIG '' HIS+qUso64cM6M2asUym8CdN/3FbwJ9dGJDX9yfMISbX
'' SIG '' oIDfInSnVDD+Z9EnnpsEw9obZwNHaGdd1NJRuPrlwatk
'' SIG '' YdBJuo5kN5/eBMYb95FbK8zZf8e+5FTnEJ0PmxRakjlF
'' SIG '' xh5Zg3CCjiIjr3w/uUkOaa2PjpkNy/vuUYxCuJb53Ca6
'' SIG '' i+n/WMWWjYJLNDCCBrwwggWkoAMCAQICEAPxtOFfOoLx
'' SIG '' FJZ4s9fYR1wwDQYJKoZIhvcNAQELBQAwbDELMAkGA1UE
'' SIG '' BhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcG
'' SIG '' A1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTErMCkGA1UEAxMi
'' SIG '' RGlnaUNlcnQgSGlnaCBBc3N1cmFuY2UgRVYgUm9vdCBD
'' SIG '' QTAeFw0xMjA0MTgxMjAwMDBaFw0yNzA0MTgxMjAwMDBa
'' SIG '' MGwxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2Vy
'' SIG '' dCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20x
'' SIG '' KzApBgNVBAMTIkRpZ2lDZXJ0IEVWIENvZGUgU2lnbmlu
'' SIG '' ZyBDQSAoU0hBMikwggEiMA0GCSqGSIb3DQEBAQUAA4IB
'' SIG '' DwAwggEKAoIBAQCnU/oPsrUT8WTPhID8roA10bbXx6Ms
'' SIG '' rBosrPGErDo1EjqSkbpX5MTJ8y+oSDy31m7clyK6UXlh
'' SIG '' r0MvDbebtEkxrkRYPqShlqeHTyN+w2xlJJBVPqHKI3zF
'' SIG '' QunEemJFm33eY3TLnmMl+ISamq1FT659H8gTy3WbyeHh
'' SIG '' ivgLDJj0yj7QRap6HqVYkzY0visuKzFYZrQyEJ+d8FKh
'' SIG '' 7+g+03byQFrc+mo9G0utdrCMXO42uoPqMKhM3vELKlhB
'' SIG '' iK4AiasD0RaCICJ2615UOBJi4dJwJNvtH3DSZAmALeK2
'' SIG '' nc4f8rsh82zb2LMZe4pQn+/sNgpcmrdK0wigOXn93b89
'' SIG '' OgklAgMBAAGjggNYMIIDVDASBgNVHRMBAf8ECDAGAQH/
'' SIG '' AgEAMA4GA1UdDwEB/wQEAwIBhjATBgNVHSUEDDAKBggr
'' SIG '' BgEFBQcDAzB/BggrBgEFBQcBAQRzMHEwJAYIKwYBBQUH
'' SIG '' MAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBJBggr
'' SIG '' BgEFBQcwAoY9aHR0cDovL2NhY2VydHMuZGlnaWNlcnQu
'' SIG '' Y29tL0RpZ2lDZXJ0SGlnaEFzc3VyYW5jZUVWUm9vdENB
'' SIG '' LmNydDCBjwYDVR0fBIGHMIGEMECgPqA8hjpodHRwOi8v
'' SIG '' Y3JsMy5kaWdpY2VydC5jb20vRGlnaUNlcnRIaWdoQXNz
'' SIG '' dXJhbmNlRVZSb290Q0EuY3JsMECgPqA8hjpodHRwOi8v
'' SIG '' Y3JsNC5kaWdpY2VydC5jb20vRGlnaUNlcnRIaWdoQXNz
'' SIG '' dXJhbmNlRVZSb290Q0EuY3JsMIIBxAYDVR0gBIIBuzCC
'' SIG '' AbcwggGzBglghkgBhv1sAwIwggGkMDoGCCsGAQUFBwIB
'' SIG '' Fi5odHRwOi8vd3d3LmRpZ2ljZXJ0LmNvbS9zc2wtY3Bz
'' SIG '' LXJlcG9zaXRvcnkuaHRtMIIBZAYIKwYBBQUHAgIwggFW
'' SIG '' HoIBUgBBAG4AeQAgAHUAcwBlACAAbwBmACAAdABoAGkA
'' SIG '' cwAgAEMAZQByAHQAaQBmAGkAYwBhAHQAZQAgAGMAbwBu
'' SIG '' AHMAdABpAHQAdQB0AGUAcwAgAGEAYwBjAGUAcAB0AGEA
'' SIG '' bgBjAGUAIABvAGYAIAB0AGgAZQAgAEQAaQBnAGkAQwBl
'' SIG '' AHIAdAAgAEMAUAAvAEMAUABTACAAYQBuAGQAIAB0AGgA
'' SIG '' ZQAgAFIAZQBsAHkAaQBuAGcAIABQAGEAcgB0AHkAIABB
'' SIG '' AGcAcgBlAGUAbQBlAG4AdAAgAHcAaABpAGMAaAAgAGwA
'' SIG '' aQBtAGkAdAAgAGwAaQBhAGIAaQBsAGkAdAB5ACAAYQBu
'' SIG '' AGQAIABhAHIAZQAgAGkAbgBjAG8AcgBwAG8AcgBhAHQA
'' SIG '' ZQBkACAAaABlAHIAZQBpAG4AIABiAHkAIAByAGUAZgBl
'' SIG '' AHIAZQBuAGMAZQAuMB0GA1UdDgQWBBSP6H7wbTJqAAUj
'' SIG '' x3CXajqQ/2vq1DAfBgNVHSMEGDAWgBSxPsNpA/i/RwHU
'' SIG '' mCYaCALvY2QrwzANBgkqhkiG9w0BAQsFAAOCAQEAGTNK
'' SIG '' DIEzN9utNsnkyTq7tRsueqLi9ENCF56/TqFN4bHb6YHd
'' SIG '' nwHy5IjV6f4J/SHB7F2A0vDWwUPC/ncr2/nXkTPObNWy
'' SIG '' GTvmLtbJk0+IQI7N4fV+8Q/GWVZy6OtqQb0c1UbVfEnK
'' SIG '' ZjgVwb/gkXB3h9zJjTHJDCmiM+2N4ofNiY0/G//V4BqX
'' SIG '' i3zabfuoxrI6Zmt7AbPN2KY07BIBq5VYpcRTV6hg5ucC
'' SIG '' EqC5I2SiTbt8gSVkIb7P7kIYQ5e7pTcGr03/JqVNYUvs
'' SIG '' RkG4Zc64eZ4IlguBjIo7j8eZjKMqbphtXmHGlreKuWEt
'' SIG '' k7jrDgRD1/X+pvBi1JlqpcHB8GSUgDGCFAEwghP9AgEB
'' SIG '' MIGAMGwxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdp
'' SIG '' Q2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5j
'' SIG '' b20xKzApBgNVBAMTIkRpZ2lDZXJ0IEVWIENvZGUgU2ln
'' SIG '' bmluZyBDQSAoU0hBMikCEAhyuYvWjuZPNsPhYg8OQncw
'' SIG '' DQYJYIZIAWUDBAIBBQCggZwwGQYJKoZIhvcNAQkDMQwG
'' SIG '' CisGAQQBgjcCAQQwHAYKKwYBBAGCNwIBCzEOMAwGCisG
'' SIG '' AQQBgjcCARUwLwYJKoZIhvcNAQkEMSIEINdkJTgAjYIY
'' SIG '' viyIlnXbKHP3aQPymhF/g7Y5H3MKnW50MDAGCisGAQQB
'' SIG '' gjcCAQwxIjAgoB6AHABBAGQAbwBiAGUAIABJAG4ARABl
'' SIG '' AHMAaQBnAG4wDQYJKoZIhvcNAQEBBQAEggEAchfhaT/N
'' SIG '' N5EsuJHRgR9TmN25uPHkSXncKqC0Hd8mmk1E9QjmOzrd
'' SIG '' wYfrIsANUmpBedfktZ3bgGNxDHp0GBzdTdPYMqSC9BtG
'' SIG '' 4hx+kRnwZjjW5pw15hIJqCA9otqQ4dDRtrcd+m+cYPW7
'' SIG '' MupI0QU3Vo40cw3KJpO8stNdwRIPsrcCNO9LeivjfzsL
'' SIG '' wRFDe4DpsmQ7H57B8FvUz27Hh76eZWZnFlKizeeHeC0F
'' SIG '' w9ansF2OTIeoYZIW3dMNb5foywvcronwoLfmIVyutId9
'' SIG '' qQdGyMF8aBzUWe8nHGr3cBpzjjbP7Qy1U1hF5tSIGbzb
'' SIG '' tMwYFG/XtLqfBAjTpKh1paBQ6qGCEbIwghGuBgorBgEE
'' SIG '' AYI3AwMBMYIRnjCCEZoGCSqGSIb3DQEHAqCCEYswghGH
'' SIG '' AgEDMQ8wDQYJYIZIAWUDBAIBBQAwdwYLKoZIhvcNAQkQ
'' SIG '' AQSgaARmMGQCAQEGCWCGSAGG/WwHATAxMA0GCWCGSAFl
'' SIG '' AwQCAQUABCAKaV1AB8Jxwb9/cDVMCHlSavdSFFipKH0+
'' SIG '' l1Z0yAS3owIQXTd8j6GwURzBqTn4LkbXJxgPMjAyMjA0
'' SIG '' MTgxOTAzMjhaoIINfDCCBsYwggSuoAMCAQICEAp6Soie
'' SIG '' yZlCkAZjOE2Gl50wDQYJKoZIhvcNAQELBQAwYzELMAkG
'' SIG '' A1UEBhMCVVMxFzAVBgNVBAoTDkRpZ2lDZXJ0LCBJbmMu
'' SIG '' MTswOQYDVQQDEzJEaWdpQ2VydCBUcnVzdGVkIEc0IFJT
'' SIG '' QTQwOTYgU0hBMjU2IFRpbWVTdGFtcGluZyBDQTAeFw0y
'' SIG '' MjAzMjkwMDAwMDBaFw0zMzAzMTQyMzU5NTlaMEwxCzAJ
'' SIG '' BgNVBAYTAlVTMRcwFQYDVQQKEw5EaWdpQ2VydCwgSW5j
'' SIG '' LjEkMCIGA1UEAxMbRGlnaUNlcnQgVGltZXN0YW1wIDIw
'' SIG '' MjIgLSAyMIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIIC
'' SIG '' CgKCAgEAuSqWI6ZcvF/WSfAVghj0M+7MXGzj4CUu0jHk
'' SIG '' PECu+6vE43hdflw26vUljUOjges4Y/k8iGnePNIwUQ0x
'' SIG '' B7pGbumjS0joiUF/DbLW+YTxmD4LvwqEEnFsoWImAdPO
'' SIG '' w2z9rDt+3Cocqb0wxhbY2rzrsvGD0Z/NCcW5QWpFQiNB
'' SIG '' Wvhg02UsPn5evZan8Pyx9PQoz0J5HzvHkwdoaOVENFJf
'' SIG '' D1De1FksRHTAMkcZW+KYLo/Qyj//xmfPPJOVToTpdhiY
'' SIG '' mREUxSsMoDPbTSSF6IKU4S8D7n+FAsmG4dUYFLcERfPg
'' SIG '' OL2ivXpxmOwV5/0u7NKbAIqsHY07gGj+0FmYJs7g7a5/
'' SIG '' KC7CnuALS8gI0TK7g/ojPNn/0oy790Mj3+fDWgVifnAs
'' SIG '' 5SuyPWPqyK6BIGtDich+X7Aa3Rm9n3RBCq+5jgnTdKEv
'' SIG '' sFR2wZBPlOyGYf/bES+SAzDOMLeLD11Es0MdI1DNkdcv
'' SIG '' nfv8zbHBp8QOxO9APhk6AtQxqWmgSfl14ZvoaORqDI/r
'' SIG '' 5LEhe4ZnWH5/H+gr5BSyFtaBocraMJBr7m91wLA2JrII
'' SIG '' O/+9vn9sExjfxm2keUmti39hhwVo99Rw40KV6J67m0uy
'' SIG '' 4rZBPeevpxooya1hsKBBGBlO7UebYZXtPgthWuo+epiS
'' SIG '' Uc0/yUTngIspQnL3ebLdhOon7v59emsCAwEAAaOCAYsw
'' SIG '' ggGHMA4GA1UdDwEB/wQEAwIHgDAMBgNVHRMBAf8EAjAA
'' SIG '' MBYGA1UdJQEB/wQMMAoGCCsGAQUFBwMIMCAGA1UdIAQZ
'' SIG '' MBcwCAYGZ4EMAQQCMAsGCWCGSAGG/WwHATAfBgNVHSME
'' SIG '' GDAWgBS6FtltTYUvcyl2mi91jGogj57IbzAdBgNVHQ4E
'' SIG '' FgQUjWS3iSH+VlhEhGGn6m8cNo/drw0wWgYDVR0fBFMw
'' SIG '' UTBPoE2gS4ZJaHR0cDovL2NybDMuZGlnaWNlcnQuY29t
'' SIG '' L0RpZ2lDZXJ0VHJ1c3RlZEc0UlNBNDA5NlNIQTI1NlRp
'' SIG '' bWVTdGFtcGluZ0NBLmNybDCBkAYIKwYBBQUHAQEEgYMw
'' SIG '' gYAwJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2lj
'' SIG '' ZXJ0LmNvbTBYBggrBgEFBQcwAoZMaHR0cDovL2NhY2Vy
'' SIG '' dHMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0VHJ1c3RlZEc0
'' SIG '' UlNBNDA5NlNIQTI1NlRpbWVTdGFtcGluZ0NBLmNydDAN
'' SIG '' BgkqhkiG9w0BAQsFAAOCAgEADS0jdKbR9fjqS5k/AeT2
'' SIG '' DOSvFp3Zs4yXgimcQ28BLas4tXARv4QZiz9d5YZPvpM6
'' SIG '' 3io5WjlO2IRZpbwbmKrobO/RSGkZOFvPiTkdcHDZTt8j
'' SIG '' ImzV3/ZZy6HC6kx2yqHcoSuWuJtVqRprfdH1AglPgtal
'' SIG '' c4jEmIDf7kmVt7PMxafuDuHvHjiKn+8RyTFKWLbfOHzL
'' SIG '' +lz35FO/bgp8ftfemNUpZYkPopzAZfQBImXH6l50pls1
'' SIG '' klB89Bemh2RPPkaJFmMga8vye9A140pwSKm25x1gvQQi
'' SIG '' FSVwBnKpRDtpRxHT7unHoD5PELkwNuTzqmkJqIt+ZKJl
'' SIG '' lBH7bjLx9bs4rc3AkxHVMnhKSzcqTPNc3LaFwLtwMFV4
'' SIG '' 1pj+VG1/calIGnjdRncuG3rAM4r4SiiMEqhzzy350yPy
'' SIG '' nhngDZQooOvbGlGglYKOKGukzp123qlzqkhqWUOuX+r4
'' SIG '' DwZCnd8GaJb+KqB0W2Nm3mssuHiqTXBt8CzxBxV+NbTm
'' SIG '' tQyimaXXFWs1DoXW4CzM4AwkuHxSCx6ZfO/IyMWMWGmv
'' SIG '' qz3hz8x9Fa4Uv4px38qXsdhH6hyF4EVOEhwUKVjMb9N/
'' SIG '' y77BDkpvIJyu2XMyWQjnLZKhGhH+MpimXSuX4IvTnMxt
'' SIG '' tQ2uR2M4RxdbbxPaahBuH0m3RFu0CAqHWlkEdhGhp3cC
'' SIG '' ExwwggauMIIElqADAgECAhAHNje3JFR82Ees/ShmKl5b
'' SIG '' MA0GCSqGSIb3DQEBCwUAMGIxCzAJBgNVBAYTAlVTMRUw
'' SIG '' EwYDVQQKEwxEaWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3
'' SIG '' dy5kaWdpY2VydC5jb20xITAfBgNVBAMTGERpZ2lDZXJ0
'' SIG '' IFRydXN0ZWQgUm9vdCBHNDAeFw0yMjAzMjMwMDAwMDBa
'' SIG '' Fw0zNzAzMjIyMzU5NTlaMGMxCzAJBgNVBAYTAlVTMRcw
'' SIG '' FQYDVQQKEw5EaWdpQ2VydCwgSW5jLjE7MDkGA1UEAxMy
'' SIG '' RGlnaUNlcnQgVHJ1c3RlZCBHNCBSU0E0MDk2IFNIQTI1
'' SIG '' NiBUaW1lU3RhbXBpbmcgQ0EwggIiMA0GCSqGSIb3DQEB
'' SIG '' AQUAA4ICDwAwggIKAoICAQDGhjUGSbPBPXJJUVXHJQPE
'' SIG '' 8pE3qZdRodbSg9GeTKJtoLDMg/la9hGhRBVCX6SI82j6
'' SIG '' ffOciQt/nR+eDzMfUBMLJnOWbfhXqAJ9/UO0hNoR8XOx
'' SIG '' s+4rgISKIhjf69o9xBd/qxkrPkLcZ47qUT3w1lbU5ygt
'' SIG '' 69OxtXXnHwZljZQp09nsad/ZkIdGAHvbREGJ3HxqV3rw
'' SIG '' N3mfXazL6IRktFLydkf3YYMZ3V+0VAshaG43IbtArF+y
'' SIG '' 3kp9zvU5EmfvDqVjbOSmxR3NNg1c1eYbqMFkdECnwHLF
'' SIG '' uk4fsbVYTXn+149zk6wsOeKlSNbwsDETqVcplicu9Yem
'' SIG '' j052FVUmcJgmf6AaRyBD40NjgHt1biclkJg6OBGz9vae
'' SIG '' 5jtb7IHeIhTZgirHkr+g3uM+onP65x9abJTyUpURK1h0
'' SIG '' QCirc0PO30qhHGs4xSnzyqqWc0Jon7ZGs506o9UD4L/w
'' SIG '' ojzKQtwYSH8UNM/STKvvmz3+DrhkKvp1KCRB7UK/BZxm
'' SIG '' SVJQ9FHzNklNiyDSLFc1eSuo80VgvCONWPfcYd6T/jnA
'' SIG '' +bIwpUzX6ZhKWD7TA4j+s4/TXkt2ElGTyYwMO1uKIqjB
'' SIG '' Jgj5FBASA31fI7tk42PgpuE+9sJ0sj8eCXbsq11GdeJg
'' SIG '' o1gJASgADoRU7s7pXcheMBK9Rp6103a50g5rmQzSM7TN
'' SIG '' sQIDAQABo4IBXTCCAVkwEgYDVR0TAQH/BAgwBgEB/wIB
'' SIG '' ADAdBgNVHQ4EFgQUuhbZbU2FL3MpdpovdYxqII+eyG8w
'' SIG '' HwYDVR0jBBgwFoAU7NfjgtJxXWRM3y5nP+e6mK4cD08w
'' SIG '' DgYDVR0PAQH/BAQDAgGGMBMGA1UdJQQMMAoGCCsGAQUF
'' SIG '' BwMIMHcGCCsGAQUFBwEBBGswaTAkBggrBgEFBQcwAYYY
'' SIG '' aHR0cDovL29jc3AuZGlnaWNlcnQuY29tMEEGCCsGAQUF
'' SIG '' BzAChjVodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20v
'' SIG '' RGlnaUNlcnRUcnVzdGVkUm9vdEc0LmNydDBDBgNVHR8E
'' SIG '' PDA6MDigNqA0hjJodHRwOi8vY3JsMy5kaWdpY2VydC5j
'' SIG '' b20vRGlnaUNlcnRUcnVzdGVkUm9vdEc0LmNybDAgBgNV
'' SIG '' HSAEGTAXMAgGBmeBDAEEAjALBglghkgBhv1sBwEwDQYJ
'' SIG '' KoZIhvcNAQELBQADggIBAH1ZjsCTtm+YqUQiAX5m1tgh
'' SIG '' QuGwGC4QTRPPMFPOvxj7x1Bd4ksp+3CKDaopafxpwc8d
'' SIG '' B+k+YMjYC+VcW9dth/qEICU0MWfNthKWb8RQTGIdDAiC
'' SIG '' qBa9qVbPFXONASIlzpVpP0d3+3J0FNf/q0+KLHqrhc1D
'' SIG '' X+1gtqpPkWaeLJ7giqzl/Yy8ZCaHbJK9nXzQcAp876i8
'' SIG '' dU+6WvepELJd6f8oVInw1YpxdmXazPByoyP6wCeCRK6Z
'' SIG '' JxurJB4mwbfeKuv2nrF5mYGjVoarCkXJ38SNoOeY+/um
'' SIG '' nXKvxMfBwWpx2cYTgAnEtp/Nh4cku0+jSbl3ZpHxcpzp
'' SIG '' SwJSpzd+k1OsOx0ISQ+UzTl63f8lY5knLD0/a6fxZsNB
'' SIG '' zU+2QJshIUDQtxMkzdwdeDrknq3lNHGS1yZr5Dhzq6YB
'' SIG '' T70/O3itTK37xJV77QpfMzmHQXh6OOmc4d0j/R0o08f5
'' SIG '' 6PGYX/sr2H7yRp11LB4nLCbbbxV7HhmLNriT1ObyF5lZ
'' SIG '' ynDwN7+YAN8gFk8n+2BnFqFmut1VwDophrCYoCvtlUG3
'' SIG '' OtUVmDG0YgkPCr2B2RP+v6TR81fZvAT6gt4y3wSJ8ADN
'' SIG '' XcL50CN/AAvkdgIm2fBldkKmKYcJRyvmfxqkhQ/8mJb2
'' SIG '' VVQrH4D6wPIOK+XW+6kvRBVK5xMOHds3OBqhK/bt1nz8
'' SIG '' MYIDdjCCA3ICAQEwdzBjMQswCQYDVQQGEwJVUzEXMBUG
'' SIG '' A1UEChMORGlnaUNlcnQsIEluYy4xOzA5BgNVBAMTMkRp
'' SIG '' Z2lDZXJ0IFRydXN0ZWQgRzQgUlNBNDA5NiBTSEEyNTYg
'' SIG '' VGltZVN0YW1waW5nIENBAhAKekqInsmZQpAGYzhNhped
'' SIG '' MA0GCWCGSAFlAwQCAQUAoIHRMBoGCSqGSIb3DQEJAzEN
'' SIG '' BgsqhkiG9w0BCRABBDAcBgkqhkiG9w0BCQUxDxcNMjIw
'' SIG '' NDE4MTkwMzI4WjArBgsqhkiG9w0BCRACDDEcMBowGDAW
'' SIG '' BBSFCPOGUVyz0wd9trS3wH8bSl5B3jAvBgkqhkiG9w0B
'' SIG '' CQQxIgQgALBi13ygPLc9IM8+ux0U80b8ow7KMVCG9o5Z
'' SIG '' H14UloMwNwYLKoZIhvcNAQkQAi8xKDAmMCQwIgQgnaaQ
'' SIG '' FcNJxsGJeEW6NYKtcMiPpCk722q+nCvSU5J55jswDQYJ
'' SIG '' KoZIhvcNAQEBBQAEggIALCjcAuTxrds3nWRat9zWGMIy
'' SIG '' Wz2URA8/Dmr4abwHzvX1v6rM/pksQYnjN/SWBsTUXcd3
'' SIG '' GFQhEyhm05w2W23CxQEl21CZyUo/br6gCKj2wlgukoUb
'' SIG '' 5T3dg0EKYtJ5mhYY4fUvjMT1wvw0JTSOVpy5mb4nkfdx
'' SIG '' Ha/yQ+sI+sl0gkeGYFfDpco/AdRPpZImWfn/ZCfpo/M5
'' SIG '' rIvLOEfM9+ByTXnvftd7tiQoz+jq+GsKYzt5VUE20dSu
'' SIG '' AYYcIYtvgilnC3J8FUUZIH5+UkAimfcwa/Yp53P82akm
'' SIG '' mPJAa3zobR1EQpLmWsz2uCBVj4PhAGKY5XdznvL6Dp/r
'' SIG '' EEGtUKxluq05ptlVqo6EIEbBr5HagIWGtlDldvitLbIl
'' SIG '' P7jY4uKbSL2tzisf6VebF7Dn4SgwCEStYe/RM+F528t/
'' SIG '' luHGyS6Powhp7Cq8Kkmafgh+OHudAcly9SrifADCUgfa
'' SIG '' 1rI0Rfo1CzYQPMCbXlnq/eiy8Air2OqWVOhy/7/GQHFH
'' SIG '' IBsuMIfyJs9nrnfxZneMQv5ZcfaNZaw3c631M1SlTyFA
'' SIG '' 8WByMoiiLeMz+TsIpZkR40MCeiroMyk6SiYL5k65yMkM
'' SIG '' QtzQaUL98XoNTJbPA0MCGvGYCxx4sLPA8iw/otLyQpf6
'' SIG '' FTSDd+1gCw4fYFYjQKR2NuYI5CfZXgIBoN+7nHJUhw4=
'' SIG '' End signature block
